import zipfile
import base64
import os
import sys
import uuid

def make_newipa(ipapath, artwork_path, sinf_content, meta_data):
    try:
        zfobj = zipfile.ZipFile(ipapath)
        for name in zfobj.namelist():
            name = name.replace('\\', '/')
            if name.find('SC_Info/') > 0 and not name.endswith('SC_Info/'):
                basenamefile = os.path.basename(name)
                break

        dotindex = basenamefile.find('.')
        newsinfname = basenamefile[0:dotindex] + '.sinf'
        newsinfpath = os.path.dirname(name) + '/' + newsinfname
        zfobj.close()

        zf = zipfile.ZipFile(ipapath, "a")

        tempSinfPath = str(uuid.uuid4())
        tempSinfFile = open(tempSinfPath, 'wb')
        base64_content = base64.decodestring(sinf_content)
        tempSinfFile.write(base64_content)
        tempSinfFile.close() 
        zf.write(tempSinfPath, newsinfpath)
        os.remove(tempSinfPath)

        zf.write(artwork_path, 'iTunesArtwork')
        os.remove(artwork_path)

        tempMetaPath = str(uuid.uuid4())
        tempMetaFile = open(tempMetaPath, 'wb')
        tempMetaFile.write(meta_data)
        tempMetaFile.close()
        zf.write(tempMetaPath, 'iTunesMetadata.plist')
        os.remove(tempMetaPath)
        
        zf.close()
        return True
    except:
        print('when make_newipa happen an error')
        return False


